/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.CustomCardMaker.structure.ElementCardName;
import LegendaryCardMaker.LegendaryItem;
import java.io.File;
import java.util.Comparator;
import javax.swing.ImageIcon;

public class CustomCard
extends LegendaryItem
implements Comparator<CustomCard>,
Comparable<CustomCard> {
    public String templateName;
    public CustomTemplate template;
    public ImageIcon imageSummary;
    public boolean changed;

    public String getCardName(String exportDir) {
        int i = 1;
        String filename = String.valueOf(this.templateName.replace(" ", "")) + "_" + this.getName() + "_" + i;
        do {
            filename = String.valueOf(this.templateName.replace(" ", "")) + "_" + this.getName() + "_" + i;
            ++i;
        } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
        return filename;
    }

    public String getName() {
        return "";
    }

    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    public String generateOutputString(boolean fullExport) {
        String str = "";
        str = String.valueOf(str) + "CUSTOMCARD;\n";
        str = String.valueOf(str) + "TEMPLATE;" + this.template.templateName + "\n";
        for (CustomElement e : this.template.elements) {
            str = String.valueOf(str) + e.generateOutputString();
        }
        return str;
    }

    public String getTextExportString() {
        String str = "";
        return str;
    }

    @Override
    public int compareTo(CustomCard o) {
        return this.getCardName().compareTo(o.getCardName());
    }

    @Override
    public int compare(CustomCard o1, CustomCard o2) {
        return o1.getCardName().compareTo(o2.getCardName());
    }

    public String getCardName() {
        for (CustomElement ce : this.template.elements) {
            if (!(ce instanceof ElementCardName)) continue;
            if (((ElementCardName)ce).getSubnameValue() != null) {
                return String.valueOf(((ElementCardName)ce).getValue()) + " (" + ((ElementCardName)ce).getSubnameValue() + ") - " + this.template.templateDisplayName;
            }
            return String.valueOf(((ElementCardName)ce).getValue()) + " - " + this.template.templateDisplayName;
        }
        return this.template.templateDisplayName;
    }
}

